# This is the code implementation of "Counterfactual Fairness from Partially DAGs: A General Min-Max Optimization Framework" paper.

## Environment
The code runs well at python 3.7. The required packages are as follows:
pytorch == 1.9.1+cu111
numpy == 1.21.5
scipy == 1.7.3
pandas == 1.3.5
cdt == 0.6.0
sklearn == 1.0.2
igraph == 0.10.4

## Run the code
We run the experiments based on the causal-learn package, the github link is https://github.com/py-why/causal-learn
Please refer to the synthetic.ipynb file in the minmax_partial_graph/tests to get the synthetic experiment results. In addition, we provide the dataset for real-world experiments, named studentInfo.

## Broader Impacts

This paper proposes a general min-max optimization framework that can effectively achieve counterfactual fairness when the true causal graph is unknown or partially known. Specifically, Counterfactual Fairness requires that if an individual's sensitive attributes (e.g., race, gender, etc.) change in the counterfactual world, then the model's predictions should also remain the same. In contrast to statistical fairness, counterfactual fairness considers possible counterfactual decision-makings, not just based on the observed data. The implications of achieving counterfactual fairness in algorithms where the true causal graph is unknown or partially known are mainly in the following aspects. First, reducing bias: machine learning models may learn and reflect bias in the training data and unconsciously apply this bias to individuals in their predictions. Counterfactual fairness helps reduce this possible bias. Second, improve fairness: if we can achieve counterfactual fairness on partially known causal graphs, our models will be prevented from treating individuals unfairly because of their sensitive attributes. Third, enhancing trust: as our algorithms are able to process data in a fairer way, people's trust in those algorithms increases. This is critical in many areas, such as healthcare, finance, and justice. Fourth, promote policy making: understanding and addressing counterfactual fairness issues in algorithms can help policy makers better understand and regulate these technologies to ensure their fairness and transparency in practice. In a nutshell, studying how to effectively achieve counterfactual fairness in scenarios such as unknown causal graphs or the presence of hidden variables is both challenging and socially significant, and deserves more research and effort.
